<?php
session_start();
require_once "db.php"; // hakikisha $conn imeconnect

$errors = [];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $phone = trim($_POST["phone"] ?? '');
    $password = $_POST["password"] ?? '';

    if ($phone === "" || $password === "") {
        $errors[] = "All fields are required.";
    } else {
        // sanitize namba (itakuja tayari na code kutoka intl-tel-input)
        $fullPhone = preg_replace('/\s+/', '', $phone);

        $stmt = $conn->prepare("SELECT id, password FROM users WHERE phone=? LIMIT 1");
        $stmt->bind_param("s", $fullPhone);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows === 1) {
            $stmt->bind_result($uid, $hashed);
            $stmt->fetch();
            if (password_verify($password, $hashed)) {
                $_SESSION["user_id"] = $uid;
                header("Location: home.php");
                exit;
            } else {
                $errors[] = "Invalid phone or password.";
            }
        } else {
            $errors[] = "Invalid phone or password.";
        }
        $stmt->close();
    }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Login - Smart360</title>

  <!-- ===== intl-tel-input CSS ===== -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/18.2.1/css/intlTelInput.css"/>

  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap');
    :root{
      --bg1:#1ca68f; --bg2:#2aa78d; --accent:#1fbf9a; --accent-dark:#16826f;
    }
    *{box-sizing:border-box;margin:0;padding:0}
    body{
      font-family:Inter,system-ui,Segoe UI,Roboto,Arial;
      background:linear-gradient(180deg,var(--bg1),var(--bg2));
      min-height:100vh;display:flex;align-items:center;justify-content:center;
      padding:20px;color:#fff;flex-direction:column;
    }
    .logo{
      font-size:28px;font-weight:800;margin-bottom:20px;letter-spacing:1px;
      background:linear-gradient(90deg,#fff,var(--accent));
      -webkit-background-clip:text;-webkit-text-fill-color:transparent;
      text-align:center;text-shadow:0 2px 6px rgba(0,0,0,0.4);
    }
    .login-box{
      width:390px;background:rgba(255,255,255,0.05);border-radius:18px;
      padding:20px;box-shadow:0 10px 30px rgba(0,0,0,0.35);
    }
    h1{font-size:20px;text-align:center;margin-bottom:14px}
    .form-group{margin-bottom:14px}
    label{display:block;margin-bottom:6px;font-weight:600;font-size:13px}
    input{
      width:100%;padding:12px;border-radius:10px;border:none;
      background:rgba(255,255,255,0.08);
      color:#fff;font-size:15px;outline:none;
    }
    input::placeholder{color:#ccc}
    button[type="submit"]{
      width:100%;padding:12px;border-radius:10px;border:none;
      background:linear-gradient(180deg,var(--accent),var(--accent-dark));
      color:#04251f;font-weight:700;font-size:15px;margin-top:6px;cursor:pointer;
    }
    .register-link{text-align:center;margin-top:14px;font-size:13px}
    .register-link a{color:#fff;font-weight:600;text-decoration:none}
    .register-link a:hover{ text-decoration:underline; }
    .alert{padding:10px;border-radius:8px;margin-bottom:10px;font-size:14px}
    .alert.error{background:#ff6b6b;color:#fff}
    @media (max-width:420px){ .login-box{width:95vw} }
    /* override flag dropdown background */
    .iti__country-list{color:#000;}
  </style>
</head>
<body>
  <div class="logo">Smart360</div>

  <div class="login-box" aria-live="polite">
    <h1>Login</h1>

    <?php if(!empty($errors)): ?>
      <div class="alert error">
        <?php foreach($errors as $e) echo htmlspecialchars($e)."<br>"; ?>
      </div>
    <?php endif; ?>

    <form id="loginForm" method="post" autocomplete="on">
      <div class="form-group">
        <label for="phone">Phone number</label>
        <input id="phone" name="phone" type="tel" placeholder="712345678" required />
      </div>

      <div class="form-group">
        <label for="password">Password</label>
        <input id="password" name="password" type="password" placeholder="Enter password" required />
      </div>

      <button type="submit">Login</button>
    </form>

    <div class="register-link">
      Don’t have an account? <a href="register.php">Register</a>
    </div>
  </div>

  <!-- ===== intl-tel-input JS ===== -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/18.2.1/js/intlTelInput.min.js"></script>
  <script>
    const input = document.querySelector("#phone");
    const iti = window.intlTelInput(input, {
      initialCountry: "us",
      preferredCountries: ["us","ke","ng","tz","ug","gb","in"],
      separateDialCode: true,
      utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/18.2.1/js/utils.js"
    });

    // before submit, set value as full international number
    document.querySelector("#loginForm").addEventListener("submit", function() {
      input.value = iti.getNumber(); 
    });
  </script>
</body>
</html>
