<?php
session_start();
require_once "db.php";

// check kama user ame-login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch current details
$stmt = $conn->prepare("SELECT username, phone FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($username, $phone);
$stmt->fetch();
$stmt->close();

$msg = "";

// Handle form submit
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $new_username = trim($_POST["username"]);
    $new_phone = trim($_POST["phone"]);
    $new_password = trim($_POST["password"]);

    if (!empty($new_password)) {
        $hashed = password_hash($new_password, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE users SET username=?, phone=?, password=? WHERE id=?");
        $stmt->bind_param("sssi", $new_username, $new_phone, $hashed, $user_id);
    } else {
        $stmt = $conn->prepare("UPDATE users SET username=?, phone=? WHERE id=?");
        $stmt->bind_param("ssi", $new_username, $new_phone, $user_id);
    }

    if ($stmt->execute()) {
        $msg = "Profile updated successfully!";
        $username = $new_username;
        $phone = $new_phone;
    } else {
        $msg = "Error updating profile.";
    }
    $stmt->close();
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Edit Profile - Smart360</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap');
    :root{
      --bg1:#1ca68f;
      --bg2:#2aa78d;
      --accent:#1fbf9a;
      --accent-dark:#16826f;
    }
    *{margin:0;padding:0;box-sizing:border-box}
    body{
      font-family:Inter,system-ui;
      background:linear-gradient(180deg,var(--bg1),var(--bg2));
      display:flex;justify-content:center;
      padding:24px 12px;
      color:#fff;
    }
    .phone{
      width:390px;min-height:580px;
      background:rgba(255,255,255,0.02);
      border-radius:28px;
      padding:18px 16px;
      box-shadow:0 18px 40px rgba(5,40,35,0.45);
    }
    h1{text-align:center;font-size:22px;margin-bottom:20px;font-weight:700}

    form{display:flex;flex-direction:column;gap:16px}
    label{font-size:14px;font-weight:500;margin-bottom:4px;display:block}
    input{
      width:100%;padding:12px;border-radius:10px;
      border:1px solid var(--accent);background:rgba(255,255,255,0.05);
      color:#fff;font-size:14px
    }
    input:focus{outline:none;border:1px solid #fff}
    .btn{
      padding:14px;
      border-radius:12px;
      font-size:15px;
      font-weight:600;
      border:none;
      cursor:pointer;
      text-align:center;
    }
    .btn-primary{background:linear-gradient(180deg,var(--accent),var(--accent-dark));color:#fff}
    .msg{text-align:center;margin-bottom:16px;font-size:14px}
    .msg.success{color:#d2f4ee}
    .msg.error{color:#ffb3b3}
    .back{margin-top:20px;text-align:center}
    .back a{color:#fff;text-decoration:none;font-size:14px}
  </style>
</head>
<body>
  <div class="phone">
    <h1>Edit Profile</h1>

    <?php if($msg): ?>
      <div class="msg <?= strpos($msg,'success')!==false ? 'success' : 'error' ?>">
        <?= htmlspecialchars($msg) ?>
      </div>
    <?php endif; ?>

    <form method="post">
      <div>
        <label>Username</label>
        <input type="text" name="username" value="<?= htmlspecialchars($username) ?>" required>
      </div>
      <div>
        <label>Phone</label>
        <input type="text" name="phone" value="<?= htmlspecialchars($phone) ?>" required>
      </div>
      <div>
        <label>New Password (leave blank to keep current)</label>
        <input type="password" name="password">
      </div>
      <button type="submit" class="btn btn-primary">Save Changes</button>
    </form>

    <div class="back">
      <a href="profile.php">← Back to Profile</a>
    </div>
  </div>
</body>
</html>
