<?php
// recharge.php
session_start();
require_once "db.php"; // DB connection

if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$message = "";

// Payment info
$payment_number = "0783004425";
$payment_network = "Airtel Money";
$payment_name = "VENIRANDA OSWANI CHIMWAGA";

if($_SERVER["REQUEST_METHOD"]=="POST"){
    $amount = floatval($_POST['amount'] ?? 0);
    $sms = trim($_POST['sms'] ?? '');

    if($amount <= 0){
        $message = "⚠ Please enter a valid amount";
    } elseif($sms == ""){
        $message = "⚠ Please paste the transaction SMS";
    } else {
        $stmt = $conn->prepare("INSERT INTO recharges(user_id, amount, payment_account, transaction_sms, status, created_at) VALUES(?,?,?,?,?,NOW())");
        $status = "pending";
        $stmt->bind_param("idsss", $user_id, $amount, $payment_number, $sms, $status);
        if($stmt->execute()){
            $message = "✅ Recharge submitted successfully!";
        } else {
            $message = "⚠ Failed to submit recharge!";
        }
        $stmt->close();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Recharge</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
body {
  margin:0;
  font-family: Arial, sans-serif;
  background: url('car.jpg') no-repeat center center fixed;
  background-size: cover;
}
.overlay {
  background: rgba(0,0,0,0.55);
  min-height: 100vh;
  display:flex;
  flex-direction:column;
  padding-bottom: 20px;
}
.header {
  color:#fff;
  text-align:center;
  padding:14px;
  font-size:21px;
  font-weight:bold;
  position:fixed;
  top:0;
  left:0;
  right:0;
  background: rgba(0,0,0,0.6);
  z-index:1000;
}
.content {
  padding:14px;
  margin-top:70px;
}

/* Recharge Card */
.recharge-card {
  background:#fff;
  border-radius:12px;
  padding:16px;
  box-shadow:0 4px 10px rgba(0,0,0,0.25);
  display:flex;
  flex-direction:column;
  gap:12px;
}
.recharge-card h3 {
  margin:0;
  font-size:16px;
  color:#2e7d32;
  text-align:center;
}
.instruction {
  font-size:13px;
  color:#444;
  background:#f1f1f1;
  padding:10px;
  border-radius:8px;
  margin-bottom:8px;
}
.amount-buttons {
  display:grid;
  grid-template-columns: repeat(4,1fr);
  gap:10px;
}
.amount-buttons button {
  padding:10px;
  border:none;
  border-radius:8px;
  background:#2e7d32;
  color:#fff;
  font-weight:bold;
  cursor:pointer;
  font-size:14px;
  transition: transform 0.2s ease;
}
.amount-buttons button:hover {
  transform: scale(1.05);
}
.copy-number {
  display:flex;
  flex-direction: column;
  gap:6px;
  background:#f1f1f1;
  padding:10px;
  border-radius:8px;
  font-size:14px;
  font-weight:bold;
  color:#333;
  margin-top:10px;
}
.copy-number span {
  display:flex;
  justify-content:space-between;
  align-items:center;
}
.copy-number button {
  background:#2e7d32;
  color:#fff;
  border:none;
  border-radius:6px;
  padding:6px 12px;
  cursor:pointer;
  font-weight:bold;
  font-size:14px;
}
.copy-number button:hover {
  background:#145214;
}
.recharge-card input[type="number"] {
  padding:10px;
  border-radius:8px;
  border:1px solid #ccc;
  font-size:14px;
  width:100%;
  box-sizing:border-box;
}
.sms-container textarea {
  width:100%;
  height:120px;
  padding:10px;
  border-radius:8px;
  border:1px solid #ccc;
  resize:none;
  font-size:14px;
  box-sizing:border-box;
}
.recharge-card button.submit-btn {
  margin-top:10px;
  padding:12px;
  background:#4caf50;
  color:#fff;
  font-weight:bold;
  border:none;
  border-radius:8px;
  cursor:pointer;
  font-size:16px;
}
.recharge-card button.submit-btn:hover {
  background:#2e7d32;
}
.message {
  background:#fff;
  color:#2e7d32;
  padding:10px;
  border-radius:8px;
  text-align:center;
  font-weight:bold;
}
.notes {
  background: rgba(255,255,255,0.9);
  border-radius:12px;
  padding:14px;
  font-size:13px;
  color:#444;
  line-height:1.5;
  box-shadow:0 4px 8px rgba(0,0,0,0.2);
  margin-top:20px;
}
.notes h4 {
  margin-top:0;
  margin-bottom:8px;
  font-size:14px;
  font-weight:bold;
  color:#2e7d32;
}
.notes ul {
  padding-left:20px;
  margin:0;
}
</style>
</head>
<body>
<div class="overlay">
  <div class="header">Recharge</div>
  <div class="content">

    <div class="recharge-card">
      <h3>Select Amount</h3>
      <div class="instruction">
        Please pay using the number below (Airtel Money) and then paste the SMS transaction exactly as received.
      </div>

      <?php if($message): ?>
        <div class="message"><?php echo $message; ?></div>
      <?php endif; ?>

      <form method="post">
        <div class="amount-buttons">
          <button type="button" onclick="setAmount(15000)">15,000</button>
          <button type="button" onclick="setAmount(25000)">25,000</button>
          <button type="button" onclick="setAmount(50000)">50,000</button>
          <button type="button" onclick="setAmount(80000)">80,000</button>
          <button type="button" onclick="setAmount(100000)">100,000</button>
          <button type="button" onclick="setAmount(250000)">250,000</button>
          <button type="button" onclick="setAmount(500000)">500,000</button>
          <button type="button" onclick="setAmount(1000000)">1,000,000</button>
        </div>

        <div class="copy-number">
          <span><strong>Number:</strong> <?php echo $payment_number; ?> <button type="button" onclick="copyNumber()">Copy</button></span>
          <span><strong>Name:</strong> <?php echo $payment_name; ?></span>
          <span><strong>Network:</strong> <?php echo $payment_network; ?></span>
        </div>

        <label for="amount">Or Enter Custom Amount</label>
        <input type="number" id="amount" name="amount" placeholder="Enter amount" min="1000" required>

        <label for="sms">Paste SMS Transaction</label>
        <textarea id="sms" name="sms" placeholder="Paste your transaction message here" required></textarea>

        <button class="submit-btn" type="submit"><i class="fas fa-paper-plane"></i> Submit Recharge</button>
      </form>
    </div>

    <div class="notes">
      <h4>Notes / Guidelines</h4>
      <ul>
        <li>Choose a preset amount or enter a custom amount.</li>
        <li>Ensure SMS transaction text is copied correctly.</li>
        <li>Recharge will be verified before adding balance.</li>
        <li>Contact support if recharge is delayed.</li>
      </ul>
    </div>

  </div>
</div>

<script>
function setAmount(value){
  document.getElementById('amount').value = value;
}

function copyNumber(){
  const number = "<?php echo $payment_number; ?>";
  navigator.clipboard.writeText(number).then(() => {
    alert('Number copied: ' + number);
  }).catch(err => {
    alert('Failed to copy');
  });
}
</script>
</body>
</html>
