<?php
session_start();
require_once "db.php";

// Hakikisha user amelogin
if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Set Kenya timezone
date_default_timezone_set('Africa/Nairobi');

// Define products (replace images and prices as needed)
$products = [
    1 => ['name'=>'Car 1', 'image'=>'car1.jpg', 'daily'=>2500, 'days'=>160, 'total'=>400000, 'price'=>15000],
    2 => ['name'=>'Car 2', 'image'=>'car2.jpg', 'daily'=>5000, 'days'=>160, 'total'=>800000, 'price'=>25000],
    3 => ['name'=>'Car 3', 'image'=>'cars3.jpg', 'daily'=>10000, 'days'=>160, 'total'=>1600000, 'price'=>50000],
    4 => ['name'=>'Car 4', 'image'=>'cars4.jpg', 'daily'=>12000, 'days'=>160, 'total'=>1920000, 'price'=>80000],
    5 => ['name'=>'Car 5', 'image'=>'cars5.jpg', 'daily'=>20000, 'days'=>160, 'total'=>3200000, 'price'=>100000],
    6 => ['name'=>'Car 6', 'image'=>'car6.jpg', 'daily'=>50000, 'days'=>160, 'total'=>8000000, 'price'=>250000],
    7 => ['name'=>'Car 7', 'image'=>'car8.jpg', 'daily'=>100000, 'days'=>160, 'total'=>16000000, 'price'=>500000]
];

$message = '';
if(isset($_GET['buy'])){
    $product_id = intval($_GET['buy']);
    if(!isset($products[$product_id])){
        $message = "Product not found!";
    } else {
        $p = $products[$product_id];
        // Fetch user balance
        $stmt = $conn->prepare("SELECT balance,referred_by FROM users WHERE id=?");
        $stmt->bind_param("i",$user_id);
        $stmt->execute();
        $stmt->bind_result($balance,$referred_by);
        $stmt->fetch();
        $stmt->close();

        if($balance < $p['price']){
            $message = "Insufficient balance!";
        } else {
            // Deduct balance
            $stmt = $conn->prepare("UPDATE users SET balance=balance-? WHERE id=?");
            $stmt->bind_param("di",$p['price'],$user_id);
            $stmt->execute();
            $stmt->close();

            // Insert into investments
            $now = date('Y-m-d H:i:s'); // Nairobi time
            $already_returned = 0;
            $status = 'active';
            $stmt = $conn->prepare("INSERT INTO investments (user_id, product_id, amount, already_returned, daily_return, total_return, status, created_at, last_received_at) VALUES (?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("iidddssss",$user_id,$product_id,$p['price'],$already_returned,$p['daily'],$p['total'],$status,$now,$now);
            $stmt->execute();
            $stmt->close();

            // --- Referral Bonus System ---
            $level_percentages = [1=>0.25,2=>0.05,3=>0.01];
            $current_user = $user_id;
            for($level=1;$level<=3;$level++){
                $stmt = $conn->prepare("SELECT referred_by FROM users WHERE id=?");
                $stmt->bind_param("i",$current_user);
                $stmt->execute();
                $stmt->bind_result($upline_id);
                $stmt->fetch();
                $stmt->close();

                if(!$upline_id){
                    break;
                }

                $bonus_amount = round($p['price'] * $level_percentages[$level],2);

                $stmt = $conn->prepare("UPDATE users SET balance=balance+? WHERE id=?");
                $stmt->bind_param("di",$bonus_amount,$upline_id);
                $stmt->execute();
                $stmt->close();

                $stmt = $conn->prepare("INSERT INTO referral_bonuses (user_id, from_user_id, to_user_id, level, amount, created_at) VALUES (?,?,?,?,?,?)");
                $stmt->bind_param("iiiids",$upline_id,$user_id,$upline_id,$level,$bonus_amount,$now);
                $stmt->execute();
                $stmt->close();

                $current_user = $upline_id;
            }

            $message = "Purchase successful! Referral bonuses distributed.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Device</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
body {margin:0;font-family:Arial,sans-serif;background:url('car.jpg') no-repeat center center fixed;background-size:cover;}
.overlay {background:rgba(0,0,0,0.55);min-height:100vh;display:flex;flex-direction:column;}
.header {color:#fff;text-align:center;padding:14px;font-size:21px;font-weight:bold;position:fixed;top:0;left:0;right:0;background:rgba(0,0,0,0.6);z-index:1000;}
.tabs {display:flex;justify-content:center;border-bottom:1px solid rgba(255,255,255,0.2);position:fixed;top:50px;left:0;right:0;background:rgba(0,0,0,0.6);z-index:1000;}
.tab {flex:1;text-align:center;padding:12px 0;color:#fff;font-weight:500;cursor:pointer;position:relative;font-size:15px;}
.tab.active{font-weight:bold;}
.tab.active::after{content:"";position:absolute;bottom:0;left:25%;width:50%;height:3px;background:#fff;border-radius:2px;}
.content {padding:12px;margin-top:100px;margin-bottom:70px;}
.card {background:#fff;border-radius:12px;padding:12px;margin-bottom:18px;box-shadow:0 4px 10px rgba(0,0,0,0.2);}
.card-top {display:flex;align-items:center;gap:12px;}
.card-top img {width:115px;height:75px;border-radius:6px;object-fit:cover;}
.card-info h3 {margin:0;font-size:15px;font-weight:bold;color:#000;}
.card-info p {margin:3px 0;font-size:13px;color:red;}
.card-info span {font-size:13px;color:#555;}
.details {display:flex;justify-content:space-between;margin-top:10px;padding:8px;background:#f9f9f9;border-radius:7px;font-size:13px;color:#333;}
.details div {text-align:center;flex:1;}
.bottom-row {display:flex;justify-content:space-between;align-items:center;margin-top:10px;}
.price {font-weight:bold;color:red;font-size:14px;}
/* Green shining button */
.btn {
  position:relative;
  display:inline-block;
  padding:8px 16px;
  background: linear-gradient(145deg,#4caf50,#2e7d32);
  color:#fff;
  border-radius:8px;
  text-decoration:none;
  font-size:14px;
  font-weight:bold;
  overflow:hidden;
  box-shadow:0 3px 12px rgba(0,0,0,0.3), 0 0 15px rgba(76,175,80,0.7) inset;
  transition:all 0.3s ease;
}
.btn::before {
  content:"";
  position:absolute;
  top:0;
  left:-75%;
  width:50%;
  height:100%;
  background:rgba(255,255,255,0.3);
  transform:skewX(-25deg);
  transition:all 0.7s ease;
}
.btn:hover::before {
  left:125%;
}
.btn:hover {
  box-shadow:0 5px 15px rgba(0,0,0,0.4), 0 0 20px rgba(76,175,80,0.8) inset;
  transform:scale(1.05);
}
.message {background:#fff;color:#2e7d32;padding:10px;border-radius:8px;margin:10px 0;text-align:center;font-weight:bold;}
.bottom-nav {position:fixed;bottom:0;left:0;right:0;background:#fff;display:flex;justify-content:space-around;border-top:1px solid #ddd;z-index:1000;}
.bottom-nav a {flex:1;text-align:center;padding:8px 0;color:#555;font-size:12px;text-decoration:none;}
.bottom-nav a i {display:block;font-size:18px;margin-bottom:3px;}
.bottom-nav a.active {color:#2e7d32;font-weight:bold;}
</style>
</head>
<body>
<div class="overlay">
  <div class="header">Device</div>
  <div class="tabs">
    <div class="tab active">CARS</div>
    <div class="tab">IMMERSION</div>
    <div class="tab">LAST ESOP</div>
  </div>

  <div class="content">
    <?php if($message): ?>
      <div class="message"><?php echo $message; ?></div>
    <?php endif; ?>

    <?php foreach($products as $id=>$p): ?>
      <div class="card">
        <div class="card-top">
          <img src="<?php echo $p['image']; ?>" alt="<?php echo $p['name']; ?>">
          <div class="card-info">
            <h3><?php echo $p['name']; ?></h3>
            <p>Daily income</p>
            <span>Purchase limit 1 Product</span>
          </div>
        </div>
        <div class="details">
          <div><strong><?php echo number_format($p['daily']); ?> TZS</strong><br>Daily income</div>
          <div><strong><?php echo $p['days']; ?> days</strong><br>Period of validity</div>
          <div><strong><?php echo number_format($p['total']); ?> TZS</strong><br>Total income</div>
        </div>
        <div class="bottom-row">
          <div class="price">Price <?php echo number_format($p['price']); ?> TZS</div>
          <a href="?buy=<?php echo $id; ?>" class="btn">Buy Now</a>
        </div>
      </div>
    <?php endforeach; ?>
  </div>

 <div class="bottom-nav">
    <a href="home.php"><i class="fas fa-home"></i>Home</a>
    <a href="collect.php"><i class="fas fa-coins"></i>Collect</a>
    <a href="device.php" class="active"><i class="fas fa-microchip"></i>Device</a>
    <a href="team.php"><i class="fas fa-users"></i>Team</a>
    <a href="me.php"><i class="fas fa-user"></i>Me</a>
  </div>
</div>
</body>
</html>
