<?php
session_start();
require_once "db.php";

// Hakikisha user amelogin
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch user details
$stmt = $conn->prepare("SELECT phone, balance FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($phone, $balance);
$stmt->fetch();
$stmt->close();

// Set timezone Kenya/Tanzania
date_default_timezone_set('Africa/Nairobi');
$today = date('Y-m-d');

// Calculate Today's Income from collection_history
$stmt = $conn->prepare("SELECT SUM(amount) FROM collection_history WHERE user_id = ? AND DATE(collected_at) = ?");
$stmt->bind_param("is", $user_id, $today);
$stmt->execute();
$stmt->bind_result($today_collection);
$stmt->fetch();
$stmt->close();
$today_collection = $today_collection ?? 0;

// Calculate Today's Income from referral_bonuses
$stmt = $conn->prepare("SELECT SUM(amount) FROM referral_bonuses WHERE to_user_id = ? AND DATE(created_at) = ?");
$stmt->bind_param("is", $user_id, $today);
$stmt->execute();
$stmt->bind_result($today_referral);
$stmt->fetch();
$stmt->close();
$today_referral = $today_referral ?? 0;

$today_income = $today_collection + $today_referral;

// Calculate Total Income from collection_history
$stmt = $conn->prepare("SELECT SUM(amount) FROM collection_history WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($total_collection);
$stmt->fetch();
$stmt->close();
$total_collection = $total_collection ?? 0;

// Calculate Total Income from referral_bonuses
$stmt = $conn->prepare("SELECT SUM(amount) FROM referral_bonuses WHERE to_user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($total_referral);
$stmt->fetch();
$stmt->close();
$total_referral = $total_referral ?? 0;

$total_income = $total_collection + $total_referral;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Me</title>
  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    body {margin:0;font-family:Arial,sans-serif;background:url("car.jpg") no-repeat center center fixed;background-size:cover;}
    .overlay{background:rgba(0,0,0,0.55);min-height:100vh;display:flex;flex-direction:column;}
    .header{color:#fff;text-align:center;padding:14px;font-size:21px;font-weight:bold;position:fixed;top:0;left:0;right:0;background:rgba(0,0,0,0.6);z-index:1000;}
    .content{padding:12px;margin-top:70px;margin-bottom:90px;}
    .profile-card{background:#fff;border-radius:12px;padding:18px;text-align:center;box-shadow:0 4px 10px rgba(0,0,0,0.2);margin-bottom:18px;}
    .profile-card img{width:80px;height:80px;border-radius:50%;object-fit:cover;margin-bottom:10px;border:2px solid #2e7d32;}
    .profile-card h2{margin:5px 0;font-size:18px;color:#000;}
    .profile-card p{margin:2px 0;font-size:13px;color:#666;}
    .balance-box{background:#fff;border-radius:12px;padding:18px;text-align:center;margin-bottom:18px;box-shadow:0 4px 10px rgba(0,0,0,0.2);}
    .balance-box h3{margin:0;font-size:15px;color:#444;}
    .balance-box .amount{margin-top:6px;font-size:22px;font-weight:bold;color:#2e7d32;}
    .income-container{display:flex;gap:12px;margin-bottom:18px;}
    .income-box{flex:1;background:#fff;border-radius:12px;padding:16px;text-align:center;box-shadow:0 4px 10px rgba(0,0,0,0.2);}
    .income-box h4{margin:0;font-size:14px;color:#555;}
    .income-box .value{margin-top:6px;font-size:18px;font-weight:bold;color:#2e7d32;}
    .action-list{background:#fff;border-radius:12px;overflow:hidden;box-shadow:0 4px 10px rgba(0,0,0,0.15);}
    .action-item{display:flex;align-items:center;padding:14px;font-size:14px;color:#333;border-bottom:1px solid #eee;text-decoration:none;}
    .action-item:last-child{border-bottom:none;}
    .action-item i{font-size:18px;width:30px;text-align:center;margin-right:10px;color:#2e7d32;}
    .action-item span{flex:1;}
    .action-item .arrow{color:#aaa;}
    .action-item:hover{background:#f5f5f5;}
    .bottom-nav{position:fixed;bottom:0;left:0;right:0;background:#fff;display:flex;justify-content:space-around;border-top:1px solid #ddd;z-index:1000;}
    .bottom-nav a{flex:1;text-align:center;padding:8px 0;color:#555;font-size:12px;text-decoration:none;}
    .bottom-nav a i{display:block;font-size:18px;margin-bottom:3px;}
    .bottom-nav a.active{color:#2e7d32;font-weight:bold;}
  </style>
</head>
<body>
  <div class="overlay">
    <div class="header">Me</div>

    <div class="content">
      <!-- Profile Card -->
      <div class="profile-card">
        <img src="car.jpg" alt="User">
        <h2>BYD</h2>
        <p>+255 <?php echo htmlspecialchars($phone); ?></p>
      </div>

      <!-- Account Balance -->
      <div class="balance-box">
        <h3>Account Balance</h3>
        <div class="amount">TZS <?php echo number_format($balance); ?></div>
      </div>

      <!-- Income Boxes -->
      <div class="income-container">
        <div class="income-box">
          <h4>Today's Income</h4>
          <div class="value">TZS <?php echo number_format($today_income); ?></div>
        </div>
        <div class="income-box">
          <h4>Total Income</h4>
          <div class="value">TZS <?php echo number_format($total_income); ?></div>
        </div>
      </div>

      <!-- Action List -->
      <div class="action-list">
        <a href="recharge.php" class="action-item">
          <i class="fas fa-wallet"></i><span>Recharge</span><i class="fas fa-chevron-right arrow"></i>
        </a>
        <a href="withdraw.php" class="action-item">
          <i class="fas fa-money-bill-wave"></i><span>Withdraw</span><i class="fas fa-chevron-right arrow"></i>
        </a>
        <a href="bank.php" class="action-item">
          <i class="fas fa-credit-card"></i><span>Bank Card</span><i class="fas fa-chevron-right arrow"></i>
        </a>
        <a href="#" class="action-item">
          <i class="fas fa-shield-alt"></i><span>Security</span><i class="fas fa-chevron-right arrow"></i>
        </a>
        <a href="login.php" class="action-item">
          <i class="fas fa-sign-out"></i><span>SignOut</span><i class="fas fa-chevron-right arrow"></i>
        </a>
      </div>
    </div>

    <!-- Bottom Navigation -->
    <div class="bottom-nav">
      <a href="home.php"><i class="fas fa-home"></i>Home</a>
      <a href="collect.php"><i class="fas fa-coins"></i>Collect</a>
      <a href="device.php"><i class="fas fa-microchip"></i>Device</a>
      <a href="team.php"><i class="fas fa-users"></i>Team</a>
      <a href="me.php" class="active"><i class="fas fa-user"></i>Me</a>
    </div>
  </div>
</body>
</html>
