<?php
session_start();
require 'db.php'; // DB connection

// Hakikisha user amelogin
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$message = '';

// Process form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $method = trim($_POST['method'] ?? '');
    $account_name = trim($_POST['account_name'] ?? '');
    $account_number = trim($_POST['account_number'] ?? '');
    $fund_password = trim($_POST['fund_password'] ?? '');
    
    if (!$method || !$account_name || !$account_number || !$fund_password) {
        $message = '⚠ Please fill in all fields!';
    } else {
        // Check if user already has bank details
        $stmt = $conn->prepare("SELECT id FROM user_bank_details WHERE user_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $stmt->store_result();

        $now = date('Y-m-d H:i:s');

        if ($stmt->num_rows > 0) {
            // Update existing
            $stmt->close();
            $update = $conn->prepare("UPDATE user_bank_details SET bank_name = ?, account_name = ?, account_number = ?, fund_password = ?, created_at = ? WHERE user_id = ?");
            $update->bind_param("sssssi", $method, $account_name, $account_number, $fund_password, $now, $user_id);
            if ($update->execute()) {
                $message = '✅ Withdrawal details updated successfully!';
            } else {
                $message = '⚠ Error updating details. Try again.';
            }
            $update->close();
        } else {
            // Insert new
            $stmt->close();
            $insert = $conn->prepare("INSERT INTO user_bank_details (user_id, account_name, bank_name, account_number, fund_password, created_at) VALUES (?,?,?,?,?,?)");
            $insert->bind_param("isssss", $user_id, $account_name, $method, $account_number, $fund_password, $now);
            if ($insert->execute()) {
                $message = '✅ Withdrawal details saved successfully!';
            } else {
                $message = '⚠ Error saving details. Try again.';
            }
            $insert->close();
        }
    }
}

// Fetch existing user details to prefill form
$bank_name = $account_name = $account_number = $fund_password = '';
$stmt = $conn->prepare("SELECT bank_name, account_name, account_number, fund_password FROM user_bank_details WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$stmt->bind_result($bank_name, $account_name, $account_number, $fund_password);
$stmt->fetch();
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Withdraw / Bank Card</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
body {
  margin:0;
  font-family: Arial, sans-serif;
  background: url('car.jpg') no-repeat center center fixed;
  background-size: cover;
}
.overlay {
  background: rgba(0,0,0,0.55);
  min-height: 100vh;
  display:flex;
  flex-direction:column;
  padding-bottom: 20px;
}
.header {
  color:#fff;
  text-align:center;
  padding:14px;
  font-size:21px;
  font-weight:bold;
  position:fixed;
  top:0;
  left:0;
  right:0;
  background: rgba(0,0,0,0.6);
  z-index:1000;
}
.content {
  padding:14px;
  margin-top:70px;
}

/* Form Styles */
.withdraw-form {
  background:#fff;
  border-radius:12px;
  padding:16px;
  box-shadow:0 4px 10px rgba(0,0,0,0.25);
  display:flex;
  flex-direction:column;
  gap:12px;
}
.withdraw-form label {
  font-size:14px;
  font-weight:bold;
  color:#333;
}
.withdraw-form select, 
.withdraw-form input {
  padding:10px;
  border-radius:8px;
  border:1px solid #ccc;
  font-size:14px;
  width:100%;
  box-sizing:border-box;
}
.withdraw-form button {
  margin-top:10px;
  padding:12px;
  background:#2e7d32;
  color:#fff;
  font-weight:bold;
  border:none;
  border-radius:8px;
  cursor:pointer;
  font-size:16px;
}
.withdraw-form button:hover {
  background:#256428;
}

/* Message */
.message {
  margin-bottom:10px;
  padding:10px;
  border-radius:8px;
  font-weight:bold;
}
.message.success { background:#d4edda; color:#155724; }
.message.error { background:#f8d7da; color:#721c24; }

/* Notes */
.notes {
  background: rgba(255,255,255,0.9);
  border-radius:12px;
  padding:14px;
  font-size:13px;
  color:#444;
  line-height:1.5;
  box-shadow:0 4px 8px rgba(0,0,0,0.2);
  margin-top:20px;
}
.notes h4 {
  margin-top:0;
  margin-bottom:8px;
  font-size:14px;
  font-weight:bold;
  color:#2e7d32;
}
.notes ul {
  padding-left:20px;
  margin:0;
}
</style>
</head>
<body>
<div class="overlay">
  <div class="header">Withdraw / Payment Method</div>
  <div class="content">

    <?php if($message): ?>
      <div class="message <?php echo strpos($message,'✅')!==false?'success':'error'; ?>">
        <?php echo $message; ?>
      </div>
    <?php endif; ?>

    <form class="withdraw-form" method="POST" onsubmit="return validateForm()">
      <label for="method">Select Payment Method</label>
      <select id="method" name="method" required>
        <option value="">--Choose Payment Method--</option>
        <option value="Airtel Money" <?php if($bank_name=='Airtel Money') echo 'selected'; ?>>Airtel Money</option>
        <option value="Tigo Pesa" <?php if($bank_name=='Tigo Pesa') echo 'selected'; ?>>Tigo Pesa</option>
        <option value="HaloPesa" <?php if($bank_name=='HaloPesa') echo 'selected'; ?>>HaloPesa</option>
        <option value="M-Pesa" <?php if($bank_name=='M-Pesa') echo 'selected'; ?>>M-Pesa</option>
        <option value="Bank Account" <?php if($bank_name=='Bank Account') echo 'selected'; ?>>Bank Account</option>
      </select>

      <label for="account_name">Account Name</label>
      <input type="text" id="account_name" name="account_name" value="<?php echo htmlspecialchars($account_name); ?>" placeholder="Enter account name" required>

      <label for="account_number">Account Number / Phone Number</label>
      <input type="text" id="account_number" name="account_number" value="<?php echo htmlspecialchars($account_number); ?>" placeholder="Enter account number" required>

      <label for="fund_password">Fund Password</label>
      <input type="password" id="fund_password" name="fund_password" value="<?php echo htmlspecialchars($fund_password); ?>" placeholder="Enter fund password" required>

      <button type="submit"><i class="fas fa-paper-plane"></i> Submit</button>
    </form>

    <div class="notes">
      <h4>Notes / Guidelines</h4>
      <ul>
        <li>Ensure the account details are correct to avoid failed withdrawals.</li>
        <li>Double-check the phone number or bank account number.</li>
        <li>Use your fund password for verification of transactions.</li>
        <li>Only verified payment methods will be processed.</li>
      </ul>
    </div>

  </div>
</div>

<script>
function validateForm(){
  const method = document.getElementById('method').value;
  const name = document.getElementById('account_name').value.trim();
  const number = document.getElementById('account_number').value.trim();
  const pwd = document.getElementById('fund_password').value.trim();

  if(!method || !name || !number || !pwd){
    alert('Please fill in all fields!');
    return false;
  }
  return true;
}
</script>
</body>
</html>
