<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>BYD App - Build Your Dreams</title>

  <!-- Manifest for PWA -->
  <link rel="manifest" href="manifest.json">

  <!-- Theme color for status bar -->
  <meta name="theme-color" content="#2196f3">

  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      text-align: center;
      min-height: 100vh;
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      padding: 20px;
      /* Correct background with overlay */
      background: 
        linear-gradient(to bottom, rgba(0,0,0,0.3) 0%, rgba(255,255,255,0.6) 40%, rgba(255,255,255,0.6) 60%, rgba(0,0,0,0.3) 100%),
        url("car.jpg") no-repeat center center fixed;
      background-size: cover;
      color: #fff;
    }

    h1 {
      font-size: 28px;
      color: #2196f3;
      margin-bottom: 12px;
    }

    p {
      font-size: 16px;
      line-height: 1.5;
      max-width: 350px;
      margin: 10px auto 20px auto;
      color: #fff;
    }

    #installBtn {
      display: none;
      padding: 14px 24px;
      background: #2196f3;
      color: white;
      border: none;
      border-radius: 8px;
      font-size: 16px;
      cursor: pointer;
      box-shadow: 0 4px 12px rgba(0,0,0,0.3);
      transition: transform 0.2s, background 0.2s;
    }

    #installBtn:hover {
      background: #1976d2;
      transform: translateY(-2px);
    }

    .features {
      margin-top: 30px;
      text-align: left;
      max-width: 400px;
      background: rgba(0,0,0,0.4);
      padding: 18px;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.3);
    }

    .feature-item {
      display: flex;
      align-items: center;
      margin-bottom: 12px;
      color: #fff;
    }

    .feature-item i {
      font-size: 20px;
      margin-right: 12px;
      color: #2196f3;
      width: 30px;
      text-align: center;
    }

    footer {
      margin-top: auto;
      padding: 12px;
      font-size: 12px;
      color: #ccc;
    }

  </style>
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>
<body>
  <h1>BYD - Build Your Dreams</h1>
  <p>Join thousands of users driving into the future with BYD. Recharge easily, grow your income, use gift codes, and explore endless opportunities from anywhere.</p>

  <button id="installBtn">Install App</button>

  <div class="features">
    <div class="feature-item"><i class="fas fa-wallet"></i>Recharge your account quickly and safely</div>
    <div class="feature-item"><i class="fas fa-coins"></i>Track your daily and total earnings</div>
    <div class="feature-item"><i class="fas fa-gift"></i>Use gift codes to unlock rewards instantly</div>
    <div class="feature-item"><i class="fas fa-users"></i>Invite friends and earn referral bonuses</div>
    <div class="feature-item"><i class="fas fa-mobile-alt"></i>Access everything conveniently via your mobile</div>
    <div class="feature-item"><i class="fas fa-globe"></i>Stay updated with our official channels</div>
  </div>

  <footer>&copy; 2025 BYD. All rights reserved.</footer>

  <script>
    let deferredPrompt;
    const installBtn = document.getElementById('installBtn');

    // Show install button if beforeinstallprompt event fired
    window.addEventListener('beforeinstallprompt', (e) => {
      e.preventDefault();
      deferredPrompt = e;
      installBtn.style.display = 'inline-block';
    });

    // Handle install button click
    installBtn.addEventListener('click', async () => {
      if (deferredPrompt) {
        deferredPrompt.prompt();
        const { outcome } = await deferredPrompt.userChoice;
        if (outcome === 'accepted') {
          console.log('User accepted the install');
        } else {
          console.log('User dismissed the install');
        }
        deferredPrompt = null;
        installBtn.style.display = 'none';
      }
    });

    // Register service worker
    if ('serviceWorker' in navigator) {
      navigator.serviceWorker.register('service_worker.js')
        .then(() => console.log('Service Worker registered'))
        .catch(err => console.log('Service Worker registration failed:', err));
    }
  </script>
</body>
</html>
