<?php
session_start();
require_once "db.php";

// hakikisha admin
if(!isset($_SESSION['is_admin']) || $_SESSION['is_admin']!==true){
  header("Location: admin_login.php");
  exit;
}

// Approve/Reject Recharge
if(isset($_POST['action']) && $_POST['action']==='approve_recharge'){
    $id=intval($_POST['id']);
    $r=$conn->prepare("SELECT user_id,amount FROM recharges WHERE id=? AND status='pending'");
    $r->bind_param("i",$id);
    $r->execute();
    $r->bind_result($uid,$amt);
    if($r->fetch()){
        $r->close();
        $conn->query("UPDATE users SET balance=balance+$amt WHERE id=$uid");
        $conn->query("UPDATE recharges SET status='approved' WHERE id=$id");
    }
    header("Location: admin.php?tab=recharges");
    exit;
}
if(isset($_POST['action']) && $_POST['action']==='reject_recharge'){
    $id=intval($_POST['id']);
    $conn->query("UPDATE recharges SET status='rejected' WHERE id=$id");
    header("Location: admin.php?tab=recharges");
    exit;
}

// Approve/Reject Withdrawal
if(isset($_POST['action']) && $_POST['action']==='approve_withdrawal'){
    $id=intval($_POST['id']);
    $conn->query("UPDATE withdrawals SET status='approved' WHERE id=$id");
    header("Location: admin.php?tab=withdrawals");
    exit;
}
if(isset($_POST['action']) && $_POST['action']==='reject_withdrawal'){
    $id=intval($_POST['id']);
    $r=$conn->prepare("SELECT user_id,amount FROM withdrawals WHERE id=? AND status='pending'");
    $r->bind_param("i",$id);
    $r->execute();
    $r->bind_result($uid,$amt);
    if($r->fetch()){
        $r->close();
        $conn->query("UPDATE users SET balance=balance+$amt WHERE id=$uid");
        $conn->query("UPDATE withdrawals SET status='rejected' WHERE id=$id");
    }
    header("Location: admin.php?tab=withdrawals");
    exit;
}

// Edit (Users, Investments, Bank Details, Referral Bonuses)
if(isset($_POST['action']) && $_POST['action']==='edit_row'){
    $table=$_POST['table'];
    $id=intval($_POST['id']);
    $allowed=['users','investments','user_bank_details','referral_bonuses'];
    if(in_array($table,$allowed)){
        $sets=[];
        $types="";
        $vals=[];
        foreach($_POST as $k=>$v){
            if(in_array($k,['action','table','id'])) continue;
            $sets[]="$k=?";
            $types.="s";
            $vals[]=$v;
        }
        if($sets){
            $types.="i";
            $vals[]=$id;
            $sql="UPDATE $table SET ".implode(",",$sets)." WHERE id=?";
            $stmt=$conn->prepare($sql);
            $stmt->bind_param($types,...$vals);
            $stmt->execute();
        }
    }
    header("Location: admin.php?tab=".$table);
    exit;
}

$tab=$_GET['tab'] ?? 'users';
function fetchAll($conn,$table){
    $rows=[];
    $res=$conn->query("SELECT * FROM $table ORDER BY id DESC");
    while($r=$res->fetch_assoc()) $rows[]=$r;
    return $rows;
}
$rows=fetchAll($conn,$tab);
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Admin Panel</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
:root{
  --primary:#2a3b4d;
  --danger:#e53935;
  --bg:#f6f8fa;
}
body{margin:0;font-family:Inter,system-ui;background:var(--bg);color:#333;}
header{background:var(--primary);color:#fff;padding:18px 28px;display:flex;justify-content:space-between;align-items:center}
header h1{margin:0;font-size:22px;font-weight:600}
nav{display:flex;gap:10px;flex-wrap:wrap;background:#fff;padding:12px 20px;box-shadow:0 2px 4px rgba(0,0,0,0.05)}
nav a{padding:8px 14px;border-radius:6px;text-decoration:none;color:#333;font-weight:500;transition:0.2s}
nav a.active,nav a:hover{background:var(--primary);color:#fff}
main{padding:24px;max-width:1200px;margin:0 auto}
.card{background:#fff;border-radius:12px;padding:20px;box-shadow:0 4px 8px rgba(0,0,0,0.05);margin-bottom:28px}
.card h2{margin-top:0;font-size:20px;font-weight:600;border-bottom:1px solid #eee;padding-bottom:8px;margin-bottom:16px}
.table-wrap{overflow-x:auto}
table{width:100%;border-collapse:collapse;font-size:14px}
th,td{padding:10px;border-bottom:1px solid #f0f0f0;text-align:left;vertical-align:top}
tr:hover{background:#fafafa}
.action-buttons form{display:inline-block;margin:0 4px}
button.btn{background:var(--primary);color:#fff;border:0;padding:6px 10px;border-radius:4px;cursor:pointer;font-size:13px}
button.btn.red{background:var(--danger)}
.status-label{font-weight:bold;padding:4px 8px;border-radius:4px}
.status-approved{color:#fff;background:#4caf50}
.status-rejected{color:#fff;background:#e53935}
.status-pending{color:#fff;background:#ff9800}
.modal{position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);display:none;align-items:center;justify-content:center;z-index:9999}
.modal-content{background:#fff;padding:20px;border-radius:10px;max-height:90vh;overflow:auto;width:90%;max-width:500px}
.modal-content h3{margin-top:0}
.modal-content label{display:block;margin-top:10px;font-weight:500}
.modal-content input{width:100%;padding:6px;margin-top:4px;border:1px solid #ccc;border-radius:6px}
</style>
</head>
<body>
<header>
  <h1>⚙ Admin Panel</h1>
  <div><a href="logout.php" style="color:#fff;text-decoration:none">Logout</a></div>
</header>
<nav>
  <a href="?tab=users" class="<?=($tab==='users'?'active':'')?>">Users</a>
  <a href="?tab=investments" class="<?=($tab==='investments'?'active':'')?>">Investments</a>
  <a href="?tab=recharges" class="<?=($tab==='recharges'?'active':'')?>">Recharges</a>
  <a href="?tab=withdrawals" class="<?=($tab==='withdrawals'?'active':'')?>">Withdrawals</a>
  <a href="?tab=user_bank_details" class="<?=($tab==='user_bank_details'?'active':'')?>">Bank Details</a>
  <a href="?tab=referral_bonuses" class="<?=($tab==='referral_bonuses'?'active':'')?>">Referral Bonuses</a>
</nav>
<main>
  <div class="card">
    <h2><?=ucwords(str_replace('_',' ',$tab))?></h2>
    <div class="table-wrap">
      <table>
        <thead>
          <tr>
            <?php if(!empty($rows)): foreach(array_keys($rows[0]) as $col): ?>
              <th><?=htmlspecialchars($col)?></th>
            <?php endforeach; ?>
            <th>Actions</th>
            <?php else: ?>
              <th>No data</th>
            <?php endif; ?>
          </tr>
        </thead>
        <tbody>
        <?php foreach($rows as $row): ?>
          <tr>
          <?php foreach($row as $col=>$val): ?>
            <td>
              <?php if($col==='status' && in_array($tab,['recharges','withdrawals'])): ?>
                <span class="status-label status-<?=htmlspecialchars($val)?>"><?=ucfirst($val)?></span>
              <?php else: ?>
                <?=htmlspecialchars($val)?>
              <?php endif; ?>
            </td>
          <?php endforeach; ?>
          <td class="action-buttons">
            <?php if($tab==='recharges' && $row['status']==='pending'): ?>
                <form method="post">
                  <input type="hidden" name="id" value="<?=$row['id']?>">
                  <input type="hidden" name="action" value="approve_recharge">
                  <button class="btn"><i class="fa fa-check"></i> Approve</button>
                </form>
                <form method="post">
                  <input type="hidden" name="id" value="<?=$row['id']?>">
                  <input type="hidden" name="action" value="reject_recharge">
                  <button class="btn red"><i class="fa fa-times"></i> Reject</button>
                </form>
            <?php elseif($tab==='withdrawals' && $row['status']==='pending'): ?>
                <form method="post">
                  <input type="hidden" name="id" value="<?=$row['id']?>">
                  <input type="hidden" name="action" value="approve_withdrawal">
                  <button class="btn"><i class="fa fa-check"></i> Approve</button>
                </form>
                <form method="post">
                  <input type="hidden" name="id" value="<?=$row['id']?>">
                  <input type="hidden" name="action" value="reject_withdrawal">
                  <button class="btn red"><i class="fa fa-times"></i> Reject</button>
                </form>
            <?php elseif(in_array($tab,['users','investments','user_bank_details','referral_bonuses'])): ?>
              <button class="btn" onclick='openEdit(<?=json_encode($row)?>,"<?=$tab?>")'><i class="fa fa-edit"></i> Edit</button>
            <?php else: ?>
              <em>-</em>
            <?php endif; ?>
          </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</main>

<!-- Modal -->
<div class="modal" id="editModal">
  <div class="modal-content">
    <h3>Edit Record</h3>
    <form method="post" id="editForm">
      <input type="hidden" name="action" value="edit_row">
      <input type="hidden" name="table" id="editTable">
      <input type="hidden" name="id" id="editId">
      <div id="editFields"></div>
      <div style="margin-top:15px;text-align:right">
        <button class="btn" type="submit">Save</button>
        <button class="btn red" type="button" onclick="closeEdit()">Cancel</button>
      </div>
    </form>
  </div>
</div>

<script>
function openEdit(row,table){
  document.getElementById('editModal').style.display='flex';
  document.getElementById('editTable').value=table;
  document.getElementById('editId').value=row.id;
  let html='';
  for(let key in row){
    if(key==='id') continue;
    html+=`
      <label>
        ${key}
        <input type="text" name="${key}" value="${row[key] ?? ''}">
      </label>
    `;
  }
  document.getElementById('editFields').innerHTML=html;
}
function closeEdit(){
  document.getElementById('editModal').style.display='none';
}
</script>
</body>
</html>
