<?php
// earn.php
session_start();
require_once "db.php"; // Lazima iwe na $conn ya mysqli

if (!isset($_SESSION['user_id'])) {
    die("You must be logged in.");
}
$user_id = $_SESSION['user_id'];

// ===============================
// Fetch user balance
// ===============================
$balance = 0;
$resBal = mysqli_query($conn, "SELECT balance FROM users WHERE id=$user_id");
if ($resBal && mysqli_num_rows($resBal) > 0) {
    $balance = mysqli_fetch_assoc($resBal)['balance'];
}

// ===============================
// Fetch active investment
// ===============================
$investment = null;
$resInv = mysqli_query($conn, "SELECT * FROM investments WHERE user_id=$user_id AND status='running' ORDER BY id DESC LIMIT 1");
if ($resInv && mysqli_num_rows($resInv) > 0) {
    $investment = mysqli_fetch_assoc($resInv);
}

$can_roll = false;
$next_time = null;
$daily_income = 0;

if ($investment) {
    $daily_income = $investment['daily_income'];
    if (is_null($investment['received_at'])) {
        $created_at = strtotime($investment['created_at']);
        $next_time = $created_at + 86400; 
    } else {
        $received_at = strtotime($investment['received_at']);
        $next_time = $received_at + 86400; 
    }
    if (time() >= $next_time) {
        $can_roll = true;
    }
}

// ===============================
// Handle roll dice request
// ===============================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['roll'])) {
    if ($can_roll && $investment) {
        // Update user balance
        $newBal = $balance + $daily_income;
        mysqli_query($conn, "UPDATE users SET balance=$newBal WHERE id=$user_id");

        // Update investment received_at
        mysqli_query($conn, "UPDATE investments SET received_at=NOW(), next_receive=NOW() + INTERVAL 1 DAY WHERE id=".$investment['id']);

        // Insert record into roll_records
        mysqli_query($conn, "INSERT INTO roll_records (user_id, reward, rolled_at) VALUES ($user_id, $daily_income, NOW())");

        $_SESSION['reward'] = $daily_income;
        header("Location: earn.php");
        exit;
    }
}

$reward_popup = null;
if (isset($_SESSION['reward'])) {
    $reward_popup = $_SESSION['reward'];
    unset($_SESSION['reward']);
}

// ===============================
// Fetch roll records
// ===============================
$records = [];
$resRec = mysqli_query($conn, "SELECT reward, rolled_at FROM roll_records WHERE user_id=$user_id ORDER BY id DESC LIMIT 10");
if ($resRec && mysqli_num_rows($resRec) > 0) {
    while($r = mysqli_fetch_assoc($resRec)) {
        $records[] = $r;
    }
}
?>
<!doctype html>  
<html lang="en">  
<head>  
 
  <meta charset="utf-8" />  
  <meta name="viewport" content="width=device-width, initial-scale=1" />  
  <title>FCB - Roll Dice UI (Mock)</title>  
  <style>  
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap');  
    :root{  
      --bg1:#1ca68f;--bg2:#2aa78d;--accent:#f2b400;--accent-dark:#e0a400;--shadow:0 12px 24px rgba(0,0,0,0.18);  
    }  
    *{box-sizing:border-box}  
    body{margin:0;font-family:Inter,system-ui;background:linear-gradient(180deg,var(--bg1),var(--bg2));display:flex;justify-content:center;padding:24px 12px;color:#0b3f3a}  
    .phone{width:390px;min-height:780px;background:rgba(255,255,255,0.02);border-radius:28px;padding:18px 16px 98px;box-shadow:0 18px 40px rgba(5,40,35,0.45);position:relative;overflow:hidden}  
    .balance-card{margin-top:18px;background:rgba(255,255,255,0.05);padding:22px;border-radius:16px;display:flex;align-items:center;gap:18px;box-shadow:var(--shadow)}  
    .balance-value{font-weight:800;font-size:34px;color:#eafffb}  
    .dice-card{margin-top:18px;background:rgba(255,255,255,0.03);padding:22px;border-radius:18px;box-shadow:0 10px 30px rgba(2,28,26,0.35)}  
    .dice-title{font-weight:700;color:var(--accent);font-size:22px;text-align:center;margin-bottom:18px}  
    .dice-face{width:140px;height:140px;background:#fff;border-radius:18px;margin:0 auto;display:flex;align-items:center;justify-content:center;box-shadow:0 8px 18px rgba(2,28,26,0.12)}  
    .dot-face{width:18px;height:18px;background:var(--bg2);border-radius:50%}  
    .btn-roll{display:block;margin:18px auto 0;padding:18px 26px;border-radius:14px;background:linear-gradient(180deg,var(--accent),var(--accent-dark));color:#0b2b22;font-weight:800;border:none;font-size:18px;cursor:pointer;width:80%}  
    .btn-roll[disabled]{opacity:0.6;cursor:not-allowed}  
    .records{margin-top:22px;background:rgba(255,255,255,0.03);padding:18px;border-radius:16px}  
    .records h3{margin:0 0 12px;color:var(--accent);text-align:center}  
    .record{display:flex;justify-content:space-between;padding:8px 0;border-bottom:1px solid rgba(255,255,255,0.05);color:#fff;font-size:14px}  
    .record:last-child{border:none}  
    .popup{position:fixed;top:50%;left:50%;transform:translate(-50%,-50%);background:#fff;padding:24px 30px;border-radius:16px;box-shadow:0 12px 30px rgba(0,0,0,0.25);z-index:99;text-align:center;display:<?php echo $reward_popup ? 'block':'none';?>}  
    .popup h2{margin:0 0 12px;font-size:22px;color:#0b2b22}  
    .popup button{margin-top:16px;padding:10px 18px;border:none;border-radius:10px;background:var(--accent);color:#0b2b22;font-weight:700;cursor:pointer}  
  </style>  
</head>  
<body>  
  <div class="phone">  
    <div class="balance-card">  
      <div class="balance-value"><?php echo $balance; ?> USDT</div>  
    </div>  
   
    <div class="records">  
      <h3>Earning Records</h3>  
      <?php if(count($records) > 0): ?>  
        <?php foreach($records as $rec): ?>  
          <div class="record">  
            <div>+<?php echo $rec['reward']; ?> USDT</div>  
            <div><?php echo date("M d, H:i", strtotime($rec['rolled_at'])); ?></div>  
          </div>  
        <?php endforeach; ?>  
      <?php else: ?>  
        <p style="color:#ccc;text-align:center">No earnings yet.</p>  
      <?php endif; ?>  
    </div>  
  </div>  
  <div class="popup" id="popup">  
    <h2>🎉 Reward Earned!</h2>  
    <p>You received <strong><?php echo $reward_popup ?? ''; ?> USDT</strong></p>  
    <button onclick="document.getElementById('popup').style.display='none'">Close</button>  
  </div>  
 
</body>
</html>
