<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Recharge.php
session_start();
require 'db.php'; // DB connection

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_SESSION['user_id'] ?? 0;
    $coin = $_POST['coin'] ?? '';
    $address = $_POST['address'] ?? '';
    $amount = $_POST['amount'] ?? 0;
    $status = "pending";
    $created_at = date("Y-m-d H:i:s");

    // Upload screenshot
    $screenshotName = "";
    if (isset($_FILES['txScreenshot']) && $_FILES['txScreenshot']['error'] === 0) {
        $ext = pathinfo($_FILES['txScreenshot']['name'], PATHINFO_EXTENSION);
        $screenshotName = "ss_" . time() . "_" . rand(1000,9999) . "." . $ext;
        $uploadPath = __DIR__ . "/uploads/" . $screenshotName;
        if (!is_dir(__DIR__ . "/uploads")) {
            mkdir(__DIR__ . "/uploads", 0777, true);
        }
        move_uploaded_file($_FILES['txScreenshot']['tmp_name'], $uploadPath);
    }

    // Insert into DB
    $stmt = $conn->prepare("INSERT INTO usdt_recharges (user_id, coin, address, amount, tx_screenshot, status, created_at) VALUES (?,?,?,?,?,?,?)");
    $stmt->bind_param("issdsss", $user_id, $coin, $address, $amount, $screenshotName, $status, $created_at);
    if ($stmt->execute()) {
        $successMsg = "Recharge submitted successfully and is pending approval.";
    } else {
        $errorMsg = "Error saving recharge: " . $conn->error;
    }
}
?>
<!doctype html>
<html lang="sw">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Recharge</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap');
    :root{
      --bg1:#1ca68f;
      --bg2:#2aa78d;
      --accent:#1fbf9a;
      --accent-dark:#16826f;
    }
    *{margin:0;padding:0;box-sizing:border-box}
    body{
      font-family:Inter,system-ui;
      background:linear-gradient(180deg,var(--bg1),var(--bg2));
      display:flex;justify-content:center;
      padding:24px 12px;
      color:#fff;
    }
    .phone{
      width:390px;min-height:780px;
      background:rgba(255,255,255,0.02);
      border-radius:28px;
      padding:18px 16px 98px;
      box-shadow:0 18px 40px rgba(5,40,35,0.45);
      position:relative;
      display:flex;flex-direction:column;
    }
    h1{text-align:center;font-size:22px;margin-bottom:20px;font-weight:700}
    .msg{padding:10px;margin-bottom:15px;border-radius:8px;font-size:14px;text-align:center}
    .msg.success{background:rgba(0,255,100,0.2);color:#0f0}
    .msg.error{background:rgba(255,0,0,0.2);color:#f88}

    .screen{display:none;flex-direction:column;flex:1}
    .screen.active{display:flex}

    .list{flex:1;overflow:auto;margin-top:10px}
    .item{
      display:flex;align-items:center;gap:16px;
      padding:14px 18px;margin-bottom:10px;
      background:rgba(0,0,0,0.25);
      border-radius:14px;cursor:pointer;
      font-size:15px;font-weight:600;
    }
    .item img{width:34px;height:34px;border-radius:50%}

    .card{
      background:rgba(0,0,0,0.25);
      border-radius:16px;
      padding:20px;
      text-align:center;
      margin-bottom:16px;
    }
    .qrwrap{display:inline-block;padding:10px;border-radius:12px;
      background:#fff;box-shadow:0 8px 18px rgba(0,0,0,.4)}
    .qr{width:170px;height:170px}
    .coin{display:flex;align-items:center;justify-content:center;gap:12px;margin:18px 0}
    .coin img{width:44px;height:44px;border-radius:50%}
    .coin .name{font-weight:700;font-size:18px}

    .labeltxt{display:block;text-align:left;color:#bbb;font-size:14px;margin:10px 0 6px}
    .address{display:flex;align-items:center;gap:12px;background:rgba(255,255,255,.05);padding:12px;border-radius:12px}
    .addr{flex:1;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;font-weight:600}
    .copy{color:var(--accent);font-weight:700;cursor:pointer}

    .uploadBox{margin-top:14px;text-align:left}
    .uploadBox label{display:block;margin-bottom:6px;color:#bbb}
    .uploadBox input{width:100%;padding:12px;border-radius:10px;border:none;background:rgba(255,255,255,0.1);color:#fff}

    .btn{
      display:block;
      width:100%;
      padding:14px;
      border-radius:12px;
      border:none;
      cursor:pointer;
      font-size:15px;
      font-weight:700;
      background:linear-gradient(180deg,var(--accent),var(--accent-dark));
      color:#fff;
      margin-top:20px;
    }

    .reminder{
      background:rgba(0,0,0,0.25);
      padding:16px;
      border-radius:12px;
      font-size:13px;
      line-height:1.6;
    }
    .reminder h4{font-size:14px;font-weight:700;color:var(--accent);margin-bottom:8px}
    .reminder ol{padding-left:18px}
    .reminder li{margin-bottom:4px}
    .back{cursor:pointer;margin-bottom:12px;color:var(--accent)}
  </style>
</head>
<body>
<div class="phone">

  <?php if(isset($successMsg)): ?>
    <div class="msg success"><?= $successMsg ?></div>
  <?php elseif(isset($errorMsg)): ?>
    <div class="msg error"><?= $errorMsg ?></div>
  <?php endif; ?>

  <!-- Select Screen -->
  <div id="selectScreen" class="screen active">
    <h1>Select Coin</h1>
    <div class="list">
         <div class="item" onclick="openRecharge('BNB','bnb')"><img src="bnb.jpg">BNB</div>
      <div class="item" onclick="openRecharge('BEP20-USDT','bep20usdt')"><img src="usdt.jpg">BEP20-USDT</div>
      <div class="item" onclick="openRecharge('POLYGON-USDC','polygonusdc')"><img src="usdc.jpg">POLYGON-USDC</div>
      <div class="item" onclick="openRecharge('TRC20-USDT','trc20usdt')"><img src="trc20.jpg">TRC20-USDT</div>
      <div class="item" onclick="openRecharge('TRX','trx')"><img src="trx.jpg">TRX</div>
      <div class="item" onclick="openRecharge('POLYGON-USDT','polygonusdt')"><img src="poly.jpg">POLYGON-USDT</div>
      <div class="item" onclick="openRecharge('ETH-USDT','ethusdt')"><img src="eth.jpg">ETH-USDT</div>
      <div class="item" onclick="openRecharge('BEP20-USDC','bep20usdc')"><img src="bep.jpg">BEP20-USDC</div>
     
    </div>
  </div>

  <!-- Recharge Screen -->
  <div id="rechargeScreen" class="screen">
    <div class="back" onclick="goBack()">← Back</div>
    <h1>Recharge</h1>
    <form method="POST" enctype="multipart/form-data">
      <div class="card">
        <div class="qrwrap"><div id="qrcode" class="qr"></div></div>
        <div class="coin">
          <img id="coinLogo" src="">
          <div class="name" id="coinName">--</div>
        </div>
        <label class="labeltxt">Deposit Address</label>
        <div class="address">
          <div class="addr" id="addrText">0x1234567890abcdef</div>
          <div class="copy" onclick="copyAddr()">Copy</div>
        </div>
        <input type="hidden" name="coin" id="coinInput">
        <input type="hidden" name="address" id="addressInput">

        <div class="uploadBox">
          <label>Enter Amount (Coin):</label>
          <input type="number" step="0.0001" name="amount" required>
        </div>

        <div class="uploadBox">
          <label>Upload Transaction Screenshot:</label>
          <input type="file" name="txScreenshot" accept="image/*" required>
        </div>

        <button type="submit" class="btn">SUBMIT RECHARGE</button>
      </div>
    </form>

    <div class="reminder">
      <h4>⚠ Warm reminder</h4>
      <ol>
        <li>Copy the above address or scan the QR code and choose correct network</li>
        <li>Please do not recharge other non-matching assets.</li>
        <li>A single recharge must meet minimum requirements.</li>
        <li>If not arrived long time, refresh page or contact service.</li>
      </ol>
    </div>
  </div>

</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
<script>
const logos={
  bep20usdt:"usdt.jpg",
  trc20usdt:"trc20.jpg",
  polygonusdt:"poly.jpg",
  ethusdt:"eth.jpg",
  polygonusdc:"usdc.jpg",
  bep20usdc:"bep.jpg",
  trx:"trx.jpg",
  bnb:"bnb.jpg"
};
const addresses={
  bep20usdt:"0x84a15d4749bfa591898b19da2b9aaa79e72a360f",
  polygonusdc:"0x84a15d4749bfa591898b19da2b9aaa79e72a360f",
  trc20usdt:"TDkwbbSCoSMf1LkqiZFPkKkS5hkA2Mr4uc",
  trx:"TDkwbbSCoSMf1LkqiZFPkKkS5hkA2Mr4uc",
  polygonusdt:"0x84a15d4749bfa591898b19da2b9aaa79e72a360f",
  ethusdt:"0x84a15d4749bfa591898b19da2b9aaa79e72a360f",
  bep20usdc:"0x84a15d4749bfa591898b19da2b9aaa79e72a360f",
  bnb:"0x84a15d4749bfa591898b19da2b9aaa79e72a360f"
};
function openRecharge(coin,key){
  document.getElementById('selectScreen').classList.remove('active');
  document.getElementById('rechargeScreen').classList.add('active');
  document.getElementById('coinLogo').src=logos[key]||"";
  document.getElementById('coinName').textContent=coin;
  const addr=addresses[key]||"Not available";
  document.getElementById('addrText').textContent=addr;
  document.getElementById('coinInput').value=coin;
  document.getElementById('addressInput').value=addr;
  document.getElementById("qrcode").innerHTML="";
  new QRCode(document.getElementById("qrcode"),{text:addr,width:170,height:170});
}
function goBack(){
  document.getElementById('rechargeScreen').classList.remove('active');
  document.getElementById('selectScreen').classList.add('active');
}
function copyAddr(){
  const txt=document.getElementById('addrText').textContent;
  navigator.clipboard?.writeText(txt).then(()=>{alert('Address copied');});
}
</script>
</body>
</html>
