<?php
// transactions.php
session_start();
require_once "db.php"; // lazima iwe na $conn

if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}
$user_id = $_SESSION['user_id'];

// Fetch withdrawals
$withdrawals = [];
$sql = "SELECT amount, actual_arrival, status, created_at 
        FROM usdt_withdrawals 
        WHERE user_id=? ORDER BY created_at DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$res = $stmt->get_result();
while($row = $res->fetch_assoc()){
    $withdrawals[] = $row;
}
$stmt->close();

// Fetch deposits
$deposits = [];
$sql = "SELECT amount, status, created_at 
        FROM usdt_recharges 
        WHERE user_id=? ORDER BY created_at DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$res = $stmt->get_result();
while($row = $res->fetch_assoc()){
    $deposits[] = $row;
}
$stmt->close();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width,initial-scale=1"/>
  <title>Smart360 - Transactions</title>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap');
    :root{
      --bg1:#1ca68f;
      --bg2:#2aa78d;
      --accent:#1fbf9a;
      --accent-dark:#16826f;
      --red:#ff4d4d;
      --green:#4dff88;
    }
    *{margin:0;padding:0;box-sizing:border-box}
    body{
      font-family:Inter,system-ui;
      background:linear-gradient(180deg,var(--bg1),var(--bg2));
      display:flex;justify-content:center;
      padding:24px 12px;
      color:#fff;
    }
    .phone{
      width:390px;min-height:780px;
      background:rgba(255,255,255,0.02);
      border-radius:28px;
      padding:18px 16px 98px;
      box-shadow:0 18px 40px rgba(5,40,35,0.45);
      position:relative;
    }
    h1{text-align:center;font-size:22px;margin-bottom:20px;font-weight:700}

    /* Tabs */
    .tabs{
      display:flex;
      margin-bottom:16px;
      border-radius:12px;
      overflow:hidden;
    }
    .tab{
      flex:1;
      padding:10px;
      text-align:center;
      background:rgba(0,0,0,0.25);
      cursor:pointer;
      font-weight:600;
    }
    .tab.active{
      background:linear-gradient(180deg,var(--accent),var(--accent-dark));
      color:#fff;
    }

    /* Table */
    table{
      width:100%;
      border-collapse:collapse;
      font-size:14px;
      margin-top:10px;
    }
    th,td{
      padding:10px;
      text-align:left;
      border-bottom:1px solid rgba(255,255,255,0.08);
    }
    th{font-weight:600;color:var(--accent)}
    td{color:#fff}
    .status{
      font-weight:600;
      padding:4px 8px;
      border-radius:6px;
      font-size:12px;
      display:inline-block;
    }
    .status.pending{background:rgba(255,255,255,0.1);color:#ffdf5d}
    .status.success{background:rgba(0,255,100,0.15);color:var(--green)}
    .status.failed{background:rgba(255,0,0,0.15);color:var(--red)}

    /* Hide inactive tab content */
    .tab-content{display:none;}
    .tab-content.active{display:block;}
  </style>
</head>
<body>
  <div class="phone">
    <h1>Transaction History</h1>

    <!-- Tabs -->
    <div class="tabs">
      <div class="tab active" onclick="showTab('withdraw')">Withdraw Records</div>
      <div class="tab" onclick="showTab('deposit')">Deposit Records</div>
    </div>

    <!-- Withdraw Records -->
    <div id="withdraw" class="tab-content active">
      <?php if(count($withdrawals)>0): ?>
      <table>
        <thead>
          <tr>
            <th>Amount</th>
            <th>Arrival</th>
            <th>Status</th>
            <th>Date</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($withdrawals as $w): ?>
          <tr>
            <td><?= htmlspecialchars($w['amount']) ?> USDT</td>
            <td><?= htmlspecialchars($w['actual_arrival']) ?> USDT</td>
            <td>
              <span class="status <?= strtolower($w['status']) ?>">
                <?= ucfirst($w['status']) ?>
              </span>
            </td>
            <td><?= date("Y-m-d H:i", strtotime($w['created_at'])) ?></td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
      <?php else: ?>
        <p>No withdrawal records found.</p>
      <?php endif; ?>
    </div>

    <!-- Deposit Records -->
    <div id="deposit" class="tab-content">
      <?php if(count($deposits)>0): ?>
      <table>
        <thead>
          <tr>
            <th>Amount</th>
            <th>Status</th>
            <th>Date</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($deposits as $d): ?>
          <tr>
            <td><?= htmlspecialchars($d['amount']) ?> USDT</td>
            <td>
              <span class="status <?= strtolower($d['status']) ?>">
                <?= ucfirst($d['status']) ?>
              </span>
            </td>
            <td><?= date("Y-m-d H:i", strtotime($d['created_at'])) ?></td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
      <?php else: ?>
        <p>No deposit records found.</p>
      <?php endif; ?>
    </div>
  </div>

  <script>
    function showTab(tab){
      document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
      document.querySelectorAll('.tab-content').forEach(c=>c.classList.remove('active'));
      event.target.classList.add('active');
      document.getElementById(tab).classList.add('active');
    }
  </script>
</body>
</html>
