<?php
session_start();
require_once "db.php"; // lazima iwe na $conn

// ====== Simple admin authentication ======
// Hapa mtu yeyote anachukuliwa kama admin
if (!isset($_SESSION['admin_id'])) {
    $_SESSION['admin_id'] = 1; // default admin
}

// ====== Handle Approve / Reject Actions ======
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $type = $_POST['type'] ?? '';
    $id = intval($_POST['id'] ?? 0);

    if ($type && $id) {
        if ($type === 'approve_recharge') {
            $sql = "SELECT user_id, amount, status FROM usdt_recharges WHERE id=? LIMIT 1";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i",$id);
            $stmt->execute();
            $result = $stmt->get_result();
            if($row = $result->fetch_assoc()){
                if($row['status'] === 'pending'){
                    $user_id = $row['user_id'];
                    $amount = $row['amount'];

                    // Update user balance
                    $update_bal = "UPDATE users SET balance = balance + ? WHERE id=?";
                    $stmt_up = $conn->prepare($update_bal);
                    $stmt_up->bind_param("di", $amount, $user_id);
                    $stmt_up->execute();

                    // Update recharge status
                    $update_sql = "UPDATE usdt_recharges SET status='approved' WHERE id=?";
                    $stmt_stat = $conn->prepare($update_sql);
                    $stmt_stat->bind_param("i", $id);
                    $stmt_stat->execute();
                }
            }

        } elseif ($type === 'reject_recharge') {
            $update_sql = "UPDATE usdt_recharges SET status='rejected' WHERE id=?";
            $stmt = $conn->prepare($update_sql);
            $stmt->bind_param("i",$id);
            $stmt->execute();
        } elseif ($type === 'approve_withdrawal') {
            $update_sql = "UPDATE usdt_withdrawals SET status='approved', updated_at=NOW() WHERE id=?";
            $stmt = $conn->prepare($update_sql);
            $stmt->bind_param("i",$id);
            $stmt->execute();
        } elseif ($type === 'reject_withdrawal') {
            $sql = "SELECT user_id, amount, status FROM usdt_withdrawals WHERE id=? LIMIT 1";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("i",$id);
            $stmt->execute();
            $result = $stmt->get_result();
            if($row = $result->fetch_assoc()){
                if($row['status']==='pending'){
                    $user_id = $row['user_id'];
                    $amount = $row['amount'];

                    // Refund balance
                    $update_bal = "UPDATE users SET balance = balance + ? WHERE id=?";
                    $stmt_up = $conn->prepare($update_bal);
                    $stmt_up->bind_param("di",$amount,$user_id);
                    $stmt_up->execute();

                    // Update withdrawal status
                    $update_sql = "UPDATE usdt_withdrawals SET status='rejected', updated_at=NOW() WHERE id=?";
                    $stmt_stat = $conn->prepare($update_sql);
                    $stmt_stat->bind_param("i",$id);
                    $stmt_stat->execute();
                }
            }
        }
    }
}

// ====== Fetch pending recharges ======
$recharges = $conn->query("SELECT r.*, u.username FROM usdt_recharges r JOIN users u ON u.id=r.user_id ORDER BY r.created_at DESC");

// ====== Fetch pending withdrawals ======
$withdrawals = $conn->query("SELECT w.*, u.username FROM usdt_withdrawals w JOIN users u ON u.id=w.user_id ORDER BY w.created_at DESC");

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Dashboard - Smart360</title>
<style>
    body{font-family:Inter,sans-serif;background:#f0f2f5;margin:0;padding:20px;}
    h1,h2{color:#1ca68f;}
    table{width:100%;border-collapse:collapse;margin-bottom:40px;}
    th,td{border:1px solid #ccc;padding:10px;text-align:left;}
    th{background:#1fbf9a;color:#fff;}
    .btn{
        padding:6px 12px;
        border:none;
        border-radius:6px;
        cursor:pointer;
        margin-right:4px;
        font-weight:600;
    }
    .approve{background:#1fbf9a;color:#fff;}
    .reject{background:#f44336;color:#fff;}
    form{display:inline;}
    .status-pending{color:#ff9800;font-weight:600;}
    .status-approved{color:#4caf50;font-weight:600;}
    .status-rejected{color:#f44336;font-weight:600;}
</style>
</head>
<body>
    <h1>Admin Dashboard</h1>

    <h2>USDT Recharges</h2>
    <table>
        <tr>
            <th>ID</th>
            <th>User</th>
            <th>Address</th>
            <th>Amount</th>
            <th>Status</th>
            <th>Created At</th>
            <th>Actions</th>
        </tr>
        <?php while($row = $recharges->fetch_assoc()): ?>
        <tr>
            <td><?= $row['id'] ?></td>
            <td><?= htmlspecialchars($row['username']) ?></td>
            <td><?= htmlspecialchars($row['address']) ?></td>
            <td><?= number_format($row['amount'],2) ?></td>
            <td class="status-<?= $row['status'] ?>"><?= ucfirst($row['status']) ?></td>
            <td><?= $row['created_at'] ?></td>
            <td>
                <?php if($row['status']==='pending'): ?>
                <form method="post">
                    <input type="hidden" name="type" value="approve_recharge">
                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                    <button class="btn approve">Approve</button>
                </form>
                <form method="post">
                    <input type="hidden" name="type" value="reject_recharge">
                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                    <button class="btn reject">Reject</button>
                </form>
                <?php else: ?>
                    -
                <?php endif; ?>
            </td>
        </tr>
        <?php endwhile; ?>
    </table>

    <h2>USDT Withdrawals</h2>
    <table>
        <tr>
            <th>ID</th>
            <th>User</th>
            <th>Mainnet</th>
            <th>Amount</th>
            <th>Fee</th>
            <th>Taxes</th>
            <th>Arrival</th>
            <th>Address</th>
            <th>Status</th>
            <th>Created At</th>
            <th>Updated At</th>
            <th>Actions</th>
        </tr>
        <?php while($row = $withdrawals->fetch_assoc()): ?>
        <tr>
            <td><?= $row['id'] ?></td>
            <td><?= htmlspecialchars($row['username']) ?></td>
            <td><?= $row['mainnet'] ?></td>
            <td><?= number_format($row['amount'],2) ?></td>
            <td><?= number_format($row['fee'],2) ?></td>
            <td><?= number_format($row['taxes'],2) ?></td>
            <td><?= number_format($row['actual_arrival'],2) ?></td>
            <td><?= htmlspecialchars($row['address']) ?></td>
            <td class="status-<?= $row['status'] ?>"><?= ucfirst($row['status']) ?></td>
            <td><?= $row['created_at'] ?></td>
            <td><?= $row['updated_at'] ?></td>
            <td>
                <?php if($row['status']==='pending'): ?>
                <form method="post">
                    <input type="hidden" name="type" value="approve_withdrawal">
                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                    <button class="btn approve">Approve</button>
                </form>
                <form method="post">
                    <input type="hidden" name="type" value="reject_withdrawal">
                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                    <button class="btn reject">Reject</button>
                </form>
                <?php else: ?>
                    -
                <?php endif; ?>
            </td>
        </tr>
        <?php endwhile; ?>
    </table>
</body>
</html>
