<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once "db.php";

$error = '';
$success = '';

// Generate unique 6-character alphanumeric referral code
function generateReferralCode($conn) {
    do {
        $code = strtoupper(substr(bin2hex(random_bytes(3)), 0, 6));
        $stmt = $conn->prepare("SELECT id FROM users WHERE referral_code = ?");
        $stmt->bind_param("s", $code);
        $stmt->execute();
        $stmt->store_result();
        $exists = $stmt->num_rows > 0;
        $stmt->close();
    } while ($exists);
    return $code;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $phone = trim($_POST['phone'] ?? '');
    $password = trim($_POST['password'] ?? '');
    $confirm = trim($_POST['confirm'] ?? '');
    $inv_code = trim($_POST['inv_code'] ?? '');

    if (empty($phone) || empty($password) || empty($confirm)) {
        $error = "Please fill all required fields.";
    } elseif ($password !== $confirm) {
        $error = "Passwords do not match.";
    } else {
        // Check existing phone
        $stmt = $conn->prepare("SELECT id FROM users WHERE phone = ?");
        $stmt->bind_param("s", $phone);
        $stmt->execute();
        $stmt->store_result();
        if ($stmt->num_rows > 0) {
            $error = "Phone number already registered.";
        } else {
            $stmt->close();

            // Referral
            $referred_by = null;
            if (!empty($inv_code)) {
                $stmt = $conn->prepare("SELECT id FROM users WHERE referral_code = ?");
                $stmt->bind_param("s", $inv_code);
                $stmt->execute();
                $stmt->bind_result($ref_id);
                if ($stmt->fetch()) {
                    $referred_by = $ref_id;
                }
                $stmt->close();
            }

            $referral_code = generateReferralCode($conn);
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $balance = 350;

            // Insert user
            if ($referred_by === null) {
                $stmt = $conn->prepare("INSERT INTO users (phone, password, balance, referral_code, created_at) VALUES (?, ?, ?, ?, NOW())");
                $stmt->bind_param("ssds", $phone, $hashed_password, $balance, $referral_code);
            } else {
                $stmt = $conn->prepare("INSERT INTO users (phone, password, balance, referral_code, referred_by, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
                $stmt->bind_param("ssdsi", $phone, $hashed_password, $balance, $referral_code, $referred_by);
            }

            if ($stmt->execute()) {
                header("Location: login.php");
                exit;
            } else {
                $error = "Registration failed: " . $stmt->error;
            }
            $stmt->close();
        }
    }
}

// Auto-fill referral from URL
$prefill_ref = $_GET['ref'] ?? '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Register</title>
<style>
body { margin:0; font-family: Arial, sans-serif; background: url("car.jpg") no-repeat center center fixed; background-size: cover; color:#fff; }
.overlay { background-color: rgba(13,15,14,0.9); width:100%; min-height:100vh; }
.container { max-width:400px; margin:0 auto; padding:30px 20px; text-align:center; }
.logo { margin-top:40px; }
.logo img { width:120px; height:120px; border-radius:50%; object-fit:cover; }
.input-group { display:flex; align-items:center; background-color:#1A1C1B; border-radius:10px; padding:0 12px; margin-top:25px; height:55px; position:relative; }
.input-group span { color:#9FA6AD; font-size:16px; margin-right:10px; }
.input-group input { flex:1; background:transparent; border:none; outline:none; font-size:16px; color:#fff; }
.input-group input::placeholder { color:#9FA6AD; }
.toggle-password { position:absolute; right:12px; cursor:pointer; width:22px; height:22px; fill:#9FA6AD; }
.btn-register { width:100%; background:#2CFF70; border:none; border-radius:10px; height:55px; font-size:18px; font-weight:bold; margin-top:25px; cursor:pointer; color:#000; }
.links { margin-top:15px; font-size:14px; }
.links a { color:#fff; text-decoration:none; margin:0 4px; }
.links a.login { color:#2CFF70; }
.error { color:#ff5555; margin-top:10px; }
</style>
</head>
<body>
<div class="overlay">
  <div class="container">

    <div class="logo">
      <img src="byds.jpg" alt="Logo">
    </div>

    <?php if(!empty($error)) echo '<div class="error">'.$error.'</div>'; ?>

    <form method="POST">
      <div class="input-group"><span>+255</span><input type="tel" name="phone" placeholder="Phone Number" required></div>
      <div class="input-group"><input type="password" id="password" name="password" placeholder="Password" required>
        <svg id="togglePassword" class="toggle-password" viewBox="0 0 24 24"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/></svg>
      </div>
      <div class="input-group"><input type="password" id="confirm" name="confirm" placeholder="Confirm Password" required>
        <svg id="toggleConfirm" class="toggle-password" viewBox="0 0 24 24"><path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z"/></svg>
      </div>
      <div class="input-group"><input type="text" name="inv_code" placeholder="Invitation Code (optional)" value="<?php echo htmlspecialchars($prefill_ref); ?>"></div>
      <button type="submit" class="btn-register">Register</button>
    </form>

    <div class="links">Already have an account? <a href="login.php" class="login">Login</a></div>
  </div>
</div>

<script>
function setupToggle(inputId, toggleId) {
  const input = document.getElementById(inputId);
  const toggle = document.getElementById(toggleId);
  toggle.addEventListener("click", () => {
    input.type = input.type === "password" ? "text" : "password";
    toggle.style.fill = input.type === "password" ? "#9FA6AD" : "#2CFF70";
  });
}
setupToggle("password", "togglePassword");
setupToggle("confirm", "toggleConfirm");
</script>
</body>
</html>
