<!DOCTYPE html>
<html lang="en">
<head>
      <link rel="manifest" href="/index/manifest.json">
  <meta name="theme-color" content="#0ea5a4">
  <link rel="icon" href="/index/icons/icon-192.png">

  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Home</title>
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: url("car.jpg") no-repeat center center fixed;
      background-size: cover;
    }
    .overlay {
      background: rgba(0,0,0,0.55);
      min-height: 100vh;
      display: flex;
      flex-direction: column;
    }

    /* HEADER */
    .header {
      color: #fff;
      text-align: center;
      padding: 14px;
      font-size: 21px;
      font-weight: bold;
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      background: rgba(0,0,0,0.6);
      z-index: 1000;
    }

    /* CONTENT */
    .content {
      padding: 14px;
      margin-top: 70px;
      margin-bottom: 90px;
    }

    /* SLIDESHOW */
    .slideshow {
      position: relative;
      width: 100%;
      height: 180px;
      border-radius: 12px;
      overflow: hidden;
      margin-bottom: 8px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.25);
    }
    .slideshow img {
      position: absolute;
      width: 100%;
      height: 100%;
      object-fit: cover;
      opacity: 0;
      animation: slideAnimation 25s infinite;
    }
    .slideshow img:nth-child(1) { animation-delay: 0s; }
    .slideshow img:nth-child(2) { animation-delay: 5s; }
    .slideshow img:nth-child(3) { animation-delay: 10s; }
    .slideshow img:nth-child(4) { animation-delay: 15s; }
    .slideshow img:nth-child(5) { animation-delay: 20s; }

    @keyframes slideAnimation {
      0% { opacity: 0; }
      4% { opacity: 1; }
      20% { opacity: 1; }
      24% { opacity: 0; }
      100% { opacity: 0; }
    }

    /* NOTICE BAR */
    .notice {
      width: 100%;
      overflow: hidden;
      margin: 10px 0 20px 0;
      background: transparent;
    }
    .notice marquee {
      font-size: 14px;
      color: #fff;
      font-weight: bold;
    }

    /* ICON GRID */
    .icon-grid {
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      gap: 20px;
      margin-bottom: 20px;
      text-align: center;
    }
    .icon-item {
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 6px;
      cursor: pointer;
    }
    .icon-box {
      background: #fff;
      border-radius: 12px;
      padding: 10px;
      display: flex;
      align-items: center;
      justify-content: center;
      box-shadow: 0 4px 10px rgba(0,0,0,0.2);
      width: 30px;
      height: 30px;
    }
    .icon-box i {
      font-size: 20px;
      color: #2e7d32;
    }
    .icon-label {
      font-size: 12px;
      font-weight: bold;
      color: #fff;
    }

    /* ACTIVITIES MARQUEE */
    .activities {
      background: #fff;
      border-radius: 12px;
      padding: 0;
      height: 150px;
      overflow: hidden;
      box-shadow: 0 4px 10px rgba(0,0,0,0.2);
    }
    .activities h3 {
      margin: 0;
      padding: 12px;
      font-size: 15px;
      text-align: center;
      color: #444;
      border-bottom: 1px solid #eee;
    }
    .activities marquee {
      display: block;
      height: 120px;
    }
    .activity-item {
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 10px 14px;
      font-size: 14px;
      color: #333;
    }
    .activity-item i {
      color: #2e7d32;
      margin-right: 10px;
      width: 20px;
      text-align: center;
    }
    .activity-item .time {
      font-size: 12px;
      color: #999;
    }

    /* BOTTOM NAV */
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: #fff;
      display: flex;
      justify-content: space-around;
      border-top: 1px solid #ddd;
      z-index: 1000;
    }
    .bottom-nav a {
      flex: 1;
      text-align: center;
      padding: 8px 0;
      color: #555;
      font-size: 12px;
      text-decoration: none;
    }
    .bottom-nav a i {
      display: block;
      font-size: 18px;
      margin-bottom: 3px;
    }
    .bottom-nav a.active {
      color: #2e7d32;
      font-weight: bold;
    }
  </style>
</head>
<body>
  <div class="overlay">

    <!-- Header -->
    <div class="header">Home</div>

    <!-- Content -->
    <div class="content">
      
      <!-- Slideshow -->
      <div class="slideshow">
        <img src="car1.jpg" alt="Slide 1">
        <img src="car2.jpg" alt="Slide 2">
        <img src="cars3.jpg" alt="Slide 3">
        <img src="car8.jpg" alt="Slide 4">
        <img src="car6.jpg" alt="Slide 5">
      </div>

      <!-- Notice -->
      <div class="notice">
       <marquee behavior="scroll" direction="left" scrollamount="5">
  🚗 Welcome to <b>BYD</b> — Drive into the future with endless opportunities &nbsp;&nbsp;
  Recharge fast, withdraw easily, and grow your income daily! &nbsp;&nbsp;
  Use gift codes to unlock instant rewards! &nbsp;&nbsp;
  Invite friends and earn extra bonuses every day! &nbsp;&nbsp;
  Trusted company with a global vision for sustainable growth. &nbsp;&nbsp;
  Download our app for a smoother and smarter experience. &nbsp;&nbsp;
  Stay tuned on our official channel for the latest updates. &nbsp;&nbsp;
  Join our group community and share success stories. &nbsp;&nbsp;
  Together with BYD, your future is bright and full of opportunities!
</marquee>
      </div>

   <!-- Icon Grid -->
<div class="icon-grid">
  <div class="icon-item" onclick="location.href='recharge.php'">
    <div class="icon-box"><i class="fas fa-wallet"></i></div>
    <div class="icon-label">Recharge</div>
  </div>

  <div class="icon-item" onclick="location.href='withdraw.php'">
    <div class="icon-box"><i class="fas fa-money-bill-wave"></i></div>
    <div class="icon-label">Withdraw</div>
  </div>

  <div class="icon-item" onclick="location.href='team.php'">
    <div class="icon-box"><i class="fas fa-user-friends"></i></div>
    <div class="icon-label">Invite</div>
  </div>

  <div class="icon-item" onclick="location.href='company.html'">
    <div class="icon-box"><i class="fas fa-building"></i></div>
    <div class="icon-label">Company</div>
  </div>

  <div class="icon-item" onclick="location.href='gift.php'">
    <div class="icon-box"><i class="fas fa-gift"></i></div>
    <div class="icon-label">Gift Code</div>
  </div>

  <div class="icon-item" onclick="location.href='app.php'">
    <div class="icon-box"><i class="fas fa-mobile-alt"></i></div>
    <div class="icon-label">App</div>
  </div>

  <div class="icon-item" onclick="window.open('https://t.me/bydofficial01','_blank')" style="cursor:pointer;">
    <div class="icon-box"><i class="fas fa-bullhorn"></i></div>
    <div class="icon-label">Channel</div>
</div>
  <div class="icon-item" onclick="location.href='group.php'">
    <div class="icon-box"><i class="fas fa-users"></i></div>
    <div class="icon-label">Group</div>
</div>
</div>


      <!-- Activities -->
      <div class="activities">
        <h3>Latest Activities</h3>
        <marquee behavior="scroll" direction="up" scrollamount="2">
          <div class="activity-item">
            <div><i class="fas fa-arrow-up"></i> 07*****655 deposited TZS 100,500</div>
            <div class="time">10:45</div>
          </div>
          <div class="activity-item">
            <div><i class="fas fa-arrow-down"></i> 07*****655 TZS 7000</div>
            <div class="time">09:20</div>
          </div>
          <div class="activity-item">
            <div><i class="fas fa-gift"></i> 07*****655 used a gift code</div>
            <div class="time">Yesterday</div>
          </div>
          <div class="activity-item">
            <div><i class="fas fa-arrow-down"></i> 07*****655 TZS 7000</div>
            <div class="time">09:20</div>
          </div>
          <div class="activity-item">
            <div><i class="fas fa-gift"></i> 07*****655 used a gift code</div>
            <div class="time">Yesterday</div>
          </div>
          <div class="activity-item">
            <div><i class="fas fa-user-friends"></i> 07*****655 invited 3 new users</div>
            <div class="time">2 days ago</div>
          </div>
        </marquee>
      </div>

    </div>

    <!-- Bottom Navigation -->
    <div class="bottom-nav">
      <a href="home.php" class="active"><i class="fas fa-home"></i>Home</a>
      <a href="collect.php"><i class="fas fa-coins"></i>Collect</a>
      <a href="device.php"><i class="fas fa-microchip"></i>Device</a>
      <a href="team.php"><i class="fas fa-users"></i>Team</a>
      <a href="me.php"><i class="fas fa-user"></i>Me</a>
    </div>
<script>
if ("serviceWorker" in navigator) {
  navigator.serviceWorker.register("service-worker.js")
  .then(reg => console.log("Service Worker registered:", reg))
  .catch(err => console.log("Service Worker failed:", err));
}
</script>
  </div>
</body>
</html>
