<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
require_once "db.php";

// Hakikisha user amelogin
if(!isset($_SESSION['user_id'])){
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Set timezone
date_default_timezone_set('Africa/Dar_es_Salaam');

// Handle collect
$message = '';
if(isset($_POST['collect'])){
    // Check if user has active investments
    $stmt = $conn->prepare("SELECT id,daily_return,already_returned,total_return,last_received_at FROM investments WHERE user_id=? AND status='active'");
    $stmt->bind_param("i",$user_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if($result->num_rows === 0){
        $message = "You don't have any active device yet. Please purchase a car first.";
    } else {
        $now = date('Y-m-d H:i:s');
        $total_collected = 0;

        while($row = $result->fetch_assoc()){
            $last = strtotime($row['last_received_at']);
            $diff = time() - $last;
            if($diff >= 86400){ // 24hrs passed
                $daily = $row['daily_return'];
                $already = $row['already_returned'] + $daily;
                $status = ($already >= $row['total_return']) ? 'completed' : 'active';

                // update investment
                $upd = $conn->prepare("UPDATE investments SET already_returned=?, last_received_at=?, status=? WHERE id=?");
                $upd->bind_param("dssi",$already,$now,$status,$row['id']);
                $upd->execute();
                $upd->close();

                // update user balance
                $upd2 = $conn->prepare("UPDATE users SET balance=balance+? WHERE id=?");
                $upd2->bind_param("di",$daily,$user_id);
                $upd2->execute();
                $upd2->close();

                // Insert into history table
                $conn->query("INSERT INTO collection_history (user_id,amount,collected_at) VALUES ($user_id,$daily,'$now')");

                $total_collected += $daily;
            }
        }

        if($total_collected>0){
            $message = "You have collected TZS ".number_format($total_collected);
        } else {
            $message = "No collection available yet. Wait for 24hrs countdown.";
        }
    }
}

// Fetch current balance
$stmt = $conn->prepare("SELECT balance FROM users WHERE id=?");
$stmt->bind_param("i",$user_id);
$stmt->execute();
$stmt->bind_result($balance);
$stmt->fetch();
$stmt->close();

// Fetch collection history
$history = [];
$res = $conn->query("SELECT amount,collected_at FROM collection_history WHERE user_id=$user_id ORDER BY collected_at DESC LIMIT 20");
while($h = $res->fetch_assoc()){
    $history[] = $h;
}

// Fetch active investments for countdown
$investments = [];
$res2 = $conn->query("SELECT id,product_id,daily_return,last_received_at FROM investments WHERE user_id=$user_id AND status='active'");
while($inv = $res2->fetch_assoc()){
    $investments[] = $inv;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Collect</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
body{margin:0;font-family:Arial,sans-serif;background:url('car.jpg') no-repeat center center fixed;background-size:cover;}
.overlay{background:rgba(0,0,0,0.55);min-height:100vh;display:flex;flex-direction:column;}
.header{color:#fff;text-align:center;padding:14px;font-size:21px;font-weight:bold;position:fixed;top:0;left:0;right:0;background:rgba(0,0,0,0.6);z-index:1000;}
.content{padding:14px;margin-top:70px;margin-bottom:90px;}
.balance-card{background:#fff;border-radius:12px;padding:20px;text-align:center;margin-bottom:20px;box-shadow:0 4px 10px rgba(0,0,0,0.25);}
.balance-card h3{margin:0;font-size:15px;color:#666;}
.balance-card .amount{font-size:28px;font-weight:bold;margin-top:8px;color:#2e7d32;}
.collect-btn{display:block;width:100%;padding:14px;border:none;border-radius:12px;background:#2e7d32;color:#fff;font-size:16px;font-weight:bold;cursor:pointer;margin-top:50px;position:relative;z-index:10;}
.collect-btn:hover{background:#256428;}
.message{background:#fff;color:#2e7d32;padding:10px;border-radius:8px;margin:10px 0;text-align:center;font-weight:bold;}
.history-box{background:#fff;border-radius:12px;padding:16px;box-shadow:0 4px 10px rgba(0,0,0,0.2);margin-top:20px;}
.history-box h4{text-align:center;margin:0 0 12px 0;font-size:15px;color:#444;}
.history-item{display:flex;justify-content:space-between;padding:10px 0;border-bottom:1px solid #eee;font-size:14px;color:#333;}
.history-item:last-child{border-bottom:none;}
.history-item .amount{font-weight:bold;color:#2e7d32;}
.countdown-box{position:absolute;top:-60px;left:50%;transform:translateX(-50%);background:rgba(255,255,255,0.15);backdrop-filter:blur(8px);padding:10px 20px;border-radius:12px;color:#fff;font-weight:bold;font-size:18px;z-index:5;text-align:center;}
.bottom-nav{position:fixed;bottom:0;left:0;right:0;background:#fff;display:flex;justify-content:space-around;border-top:1px solid #ddd;z-index:1000;}
.bottom-nav a{flex:1;text-align:center;padding:8px 0;color:#555;font-size:12px;text-decoration:none;}
.bottom-nav a i{display:block;font-size:18px;margin-bottom:3px;}
.bottom-nav a.active{color:#2e7d32;font-weight:bold;}
</style>
</head>
<body>
<div class="overlay">
  <div class="header">Collect</div>
  <div class="content">
    <?php if($message): ?>
    <div class="message"><?php echo $message; ?></div>
    <?php endif; ?>

    <div class="balance-card">
      <h3>Your Balance</h3>
      <div class="amount">TZS <?php echo number_format($balance); ?></div>
    </div>

    <?php if(count($investments)>0): 
        $nextTimes = [];
        foreach($investments as $inv){
            $last = strtotime($inv['last_received_at']);
            $nextTimes[] = $last + 86400; // next collect time
        }
        $nearest = min($nextTimes);
    ?>
      <div class="countdown-box" id="countdown">Loading...</div>
    <?php endif; ?>

    <form method="post" style="position:relative;">
      <button type="submit" name="collect" class="collect-btn"><i class="fas fa-hand-holding-usd"></i> Collect Now</button>
    </form>

    <div class="history-box">
      <h4>Collection History</h4>
      <?php foreach($history as $h): ?>
        <div class="history-item">
          <div><?php echo $h['collected_at']; ?></div>
          <div class="amount">+TZS <?php echo number_format($h['amount']); ?></div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>

  <div class="bottom-nav">
    <a href="home.php"><i class="fas fa-home"></i>Home</a>
    <a href="collect.php" class="active"><i class="fas fa-coins"></i>Collect</a>
    <a href="device.php"><i class="fas fa-microchip"></i>Device</a>
    <a href="team.php"><i class="fas fa-users"></i>Team</a>
    <a href="me.php"><i class="fas fa-user"></i>Me</a>
  </div>
</div>

<script>
<?php if(count($investments)>0): ?>
let countdownEl = document.getElementById('countdown');
let nextTime = <?php echo $nearest; ?> * 1000;

function updateCountdown(){
    const now = new Date().getTime();
    let diff = nextTime - now;
    if(diff <= 0){
        countdownEl.textContent = "Ready to collect!";
    } else {
        let hrs = Math.floor(diff/1000/3600);
        let mins = Math.floor((diff/1000%3600)/60);
        let secs = Math.floor(diff/1000%60);
        countdownEl.textContent = 
            hrs.toString().padStart(2,'0')+":"+
            mins.toString().padStart(2,'0')+":"+
            secs.toString().padStart(2,'0');
    }
}
setInterval(updateCountdown,1000);
updateCountdown();
<?php endif; ?>
</script>
</body>
</html>
